## Synopsis

NGLThread component provides a wrapper over STL async with a capability of providing a callback function if needed.

## Code Example

#### Calling NGLThread without callback function 

```c++
/*
Class whose function needs to be executed in a separate thread
*/
ThreadTestClass *threadTestClassObj = new ThreadTestClass();

/*
LongFunction is a function that needs to be executed in a different thread, it takes 2 parameters std::placeholders::_1, std::placeholders::_2.
*/
auto thredFunc = std::bind(&ThreadTestClass::LongFunction, threadTestClassObj, std::placeholders::_1, std::placeholders::_2);

/*
Below is the new Thread object creation
template NGLThread is "template <typename Task, typename Result, typename... Args>"

* Task is the function to be executed, 
* Type is the return type of the function
* Args are the argument of the function

Below sample executes a function which takes 2 int parameters and returns int.

Callback function is given as null, in case callback function is given, it should have a definition as "void Function_Name(Result)", this is explained in detailed in example below.
*/
auto *threadObj = new adobe::ngl::internal::NglThread<std::function<int(int, int)>, int, int, int>(thredFunc, nullptr, 10, 20);

/*
Start executing the thread
*/
NglThreadReturnStatus taskStatus = threadObj->StartTask();

if (taskStatus == NglThreadReturnStatus::SUCCESS) {
auto result;
/*
GetResult waits for maximum of 100 milliseconds for the result to be available by LongFunction. If result is available within 100 milliseconds, GetResult returns SUCCESS with result populated, else GetResult returns IN_PROGRESS.
*/
NglThreadReturnStatus resultStatus = threadObj->GetResult(result, 100);

} else {
//Thread exeuction failed.
}


```

#### Calling NGLThread with callback function (Comments of same lines for above are omitted)

```c++
ThreadTestClass *threadTestClassObj = new ThreadTestClass();
auto thredFunc = std::bind(&ThreadTestClass::LongFunction, threadTestClassObj, std::placeholders::_1, std::placeholders::_2);

/*
Callback function that takes parameter as the result of LongFunction
*/
auto thredFuncCb = std::bind(&ThreadTestClass::MyCallback, threadTestClassObj, std::placeholders::_1);
				

auto *threadObj = new adobe::ngl::internal::NglThread<std::function<int(int, int)>, int, int, int>(thredFunc, thredFuncCb, 10, 20);
NglThreadReturnStatus taskStatus = threadObj->StartTask();
if (taskStatus == NglThreadReturnStatus::SUCCESS) {
auto result;
/*
Get result can be called in this case as well, callnback function will be called in anycase.
*/
NglThreadReturnStatus resultStatus = threadObj->GetResult(result, 100);

} else {
//Thread exeuction failed.
}


```


## API Reference

Please see NGLThread.h for details of all the APIs

## Tests

Test of this component is executed by GTest for NGL Project.